-- pralable
-- USE BD_Air_France;


IF OBJECT_ID('dbo.T_affreter_aff','U') IS NOT NULL
   DROP TABLE dbo.T_affreter_aff;
GO
IF OBJECT_ID('dbo.T_avion_avi','U') IS NOT NULL
   DROP TABLE dbo.T_avion_avi;
GO
IF OBJECT_ID('dbo.T_compagnie_cmp','U') IS NOT NULL
   DROP TABLE dbo.T_compagnie_cmp;
GO


CREATE TABLE T_compagnie_cmp
	(cmp_comp VARCHAR(4), cmp_effectif INT, cmp_ville VARCHAR(30), cmp_nom VARCHAR(30),
 	CONSTRAINT PK_cmp PRIMARY KEY(cmp_comp));

CREATE TABLE T_avion_avi
	(avi_immat VARCHAR(6), avi_typ VARCHAR(30), avi_hv DECIMAL(10,2), 
        cmp_comp VARCHAR(4) NOT NULL,
	CONSTRAINT PK_avi PRIMARY KEY(avi_immat),
	CONSTRAINT FK_avi_cmp FOREIGN KEY(cmp_comp) REFERENCES T_compagnie_cmp(cmp_comp));

CREATE TABLE T_affreter_aff
	(cmp_comp VARCHAR(4), avi_immat VARCHAR(6), aff_datea DATE, aff_nbp SMALLINT,
	CONSTRAINT PK_aff     PRIMARY KEY (cmp_comp,avi_immat,aff_datea),
	CONSTRAINT FK_aff_avi FOREIGN KEY(avi_immat)  REFERENCES T_avion_avi(avi_immat)
              ON DELETE CASCADE ON UPDATE CASCADE,
	CONSTRAINT FK_aff_cmp FOREIGN KEY(cmp_comp) REFERENCES T_compagnie_cmp(cmp_comp));


-- rfrents
INSERT INTO T_compagnie_cmp(cmp_comp,cmp_effectif,cmp_ville,cmp_nom)
       VALUES ('AF',6700,'Paris', 'Air France');
INSERT INTO T_compagnie_cmp(cmp_comp,cmp_effectif,cmp_ville,cmp_nom)
       VALUES ('SING',3400,'Singapour','Singapore AL');
INSERT INTO T_compagnie_cmp(cmp_comp,cmp_effectif,cmp_ville,cmp_nom)
       VALUES ('AA',10560,'Chicago','American AL');

-- dpendant avec rfrent
INSERT INTO T_avion_avi(avi_immat,avi_typ,avi_hv,cmp_comp)
       VALUES ('F-WTSS','B777',6570,'SING');
INSERT INTO T_avion_avi(avi_immat,avi_typ,avi_hv,cmp_comp)
       VALUES ('F-GAFU','A320',3500,'AF');
INSERT INTO T_avion_avi(avi_immat,avi_typ,avi_hv,cmp_comp)
       VALUES ('F-GLFS','A380',2000,'SING');

-- dpendant avec rfrents
INSERT INTO T_affreter_aff(cmp_comp,avi_immat,aff_datea,aff_nbp)
       VALUES('AF','F-WTSS','2013-05-13',285);
INSERT INTO T_affreter_aff(cmp_comp,avi_immat,aff_datea,aff_nbp)
       VALUES('SING','F-GAFU','2013-02-05',155);
INSERT INTO T_affreter_aff(cmp_comp,avi_immat,aff_datea,aff_nbp)
       VALUES('SING','F-WTSS','2013-05-15',302);
INSERT INTO T_affreter_aff(cmp_comp,avi_immat,aff_datea,aff_nbp)
       VALUES('AA','F-WTSS','2013-05-16',290);



UPDATE T_avion_avi
SET    avi_immat = 'F-GNJL'
WHERE  avi_immat = 'F-WTSS';

SELECT * FROM T_affreter_aff;

DELETE FROM T_avion_avi
WHERE   avi_immat = 'F-GNJL';

SELECT * FROM T_affreter_aff;

